
using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Presenter;
using System;
using System.Collections.Generic;
using System.IO;
using inetsoftware.Pdfc.Config;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A simple sample for exporting the results of the comparison of 2 PDF Files to a PDF.
    /// Expects 2 arguments - the paths of the PDF files to be compared
    /// </summary>
    public class ExampleOCR
    {
        static ExampleOCR()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show how exporting the result of a comparison of 2 PDF Files to a PDF,
        /// showing how to set the export path for this comparison report.
        /// </summary>
        /// <param name="args">Expects 2 arguments: the paths of the 2 PDF files that will be compared.</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            IDictionary<string, string> profile = new Dictionary<string, string>();

            System.Console.WriteLine("activate OCR and text comparison");
            profile[PDFCProperty.COMPARE_TYPES] = "TEXT";
            profile[PDFCProperty.FILTERS] = "INVISIBLEELEMENTS,TEXTTRANSFORM,SOLVEFALSEREPLACE,OCR,REGEXP";
            profile["DOCUMENT_LANGUAGE"] = "eng";

            //Used the current i-net PDFC profile. If no profile has been previously set then the default profile will be used.
            DifferencesPDFPresenter differencesPDFPresenter = new DifferencesPDFPresenter(Path.GetDirectoryName(args[0]));
            using (new PDFComparer()
                            .SetProfile(profile)
                            .AddPresenter(differencesPDFPresenter)
                            .Compare(args[0], args[1]))
            { }
        }
    }
}
